package com.demo.openapi;

import com.alibaba.fastjson.JSONObject;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.CoreConnectionPNames;
import org.apache.http.util.EntityUtils;
import org.slf4j.LoggerFactory;

import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.*;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.*;

public class HttpClientUtil {
	public static final String SunX509 = "SunX509";
	public static final String JKS = "JKS";
	public static final String PKCS12 = "PKCS12";
	public static final String TLS = "TLS";
	
	private static final String encoding = "UTF-8";
	private static RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(20000).setConnectTimeout(20000).build();
	
	private static final org.slf4j.Logger logger = LoggerFactory.getLogger(HttpClientUtil.class);

	public static String doPost(String url, Map<String, Object> map, String charset) throws IOException {
		HttpClient httpClient = null;
		HttpPost httpPost = null;
		String result = null;
//		try {
			httpClient = new DefaultHttpClient();
			httpClient.getParams().setParameter(CoreConnectionPNames.CONNECTION_TIMEOUT,20000);//连接时间
			httpClient.getParams().setParameter(CoreConnectionPNames.SO_TIMEOUT,20000);//数据传输时间
			httpPost = new HttpPost(url);
			// 设置参数
			List<NameValuePair> list = new ArrayList<NameValuePair>();
			Iterator iterator = map.entrySet().iterator();
			while (iterator.hasNext()) {
				Map.Entry<String, String> elem = (Map.Entry<String, String>) iterator.next();
				list.add(new BasicNameValuePair(elem.getKey(), elem.getValue()));
			}
			if (list.size() > 0) {
				UrlEncodedFormEntity entity = new UrlEncodedFormEntity(list,
						charset);
				httpPost.setEntity(entity);
			}
			HttpResponse response = httpClient.execute(httpPost);
			if (response != null) {
				HttpEntity resEntity = response.getEntity();
				if (resEntity != null) {
					result = EntityUtils.toString(resEntity, charset);
				}
			}
//		} catch (Exception ex) {
//			ex.printStackTrace();
//		}
		return result;
	}

	public static JSONObject doPost(String url,JSONObject json) throws IOException {
		HttpClient client = new DefaultHttpClient();
		HttpPost post = new HttpPost(url);
		JSONObject response = null;
//		try {
			StringEntity s = new StringEntity(json.toString());
			s.setContentEncoding("UTF-8");
			s.setContentType("application/json");//发送json数据需要设置contentType
			post.setEntity(s);
			HttpResponse res = client.execute(post);
			if(res.getStatusLine().getStatusCode() == HttpStatus.SC_OK){
				HttpEntity entity = res.getEntity();
				String result = EntityUtils.toString(res.getEntity());// 返回json格式：
				response = JSONObject.parseObject(result);
			}
//		} catch (Exception e) {
//			throw new RuntimeException(e);
//		}
		return response;
	}

	public static JSONObject sendJson(String postUrl, JSONObject json, Map<String, String> paramMap) throws IOException {
		HttpURLConnection connection = null;
		//创建连接
		URL url = new URL(postUrl);
		connection = (HttpURLConnection) url.openConnection();
		//设置http连接属性
		connection.setDoOutput(true);
		connection.setDoInput(true);
		String requestMethod = "POST";
		if (null != paramMap.get("requestMethod") && !"".equals(paramMap.get("requestMethod"))) {
			requestMethod = paramMap.get("requestMethod");
		}
		// 可以根据需要 提交 GET、POST、DELETE、INPUT等http提供的功能
		connection.setRequestMethod(requestMethod);
		connection.setUseCaches(false);
		connection.setInstanceFollowRedirects(true);

		// 设置http头 消息
		// 设定 请求格式 json，也可以设定xml格式的
		connection.setRequestProperty("Content-Type","application/json");
		// 设定 请求格式 xml，
		//connection.setRequestProperty("Content-Type", "text/xml");
		// 设定响应的信息的格式为 json，也可以设定xml格式的
		connection.setRequestProperty("Accept","application/json");
		// 特定http服务器需要的信息，根据服务器所需要求添加
//             connection.setRequestProperty("X-Auth-Token","xx");
		// 设置BASIC AUTH
		if (null != paramMap.get("authorization") && !"".equals(paramMap.get("authorization"))) {
			connection.setRequestProperty("Authorization", paramMap.get("authorization"));
		}
		if (null != paramMap.get("uniquekey") && !"".equals(paramMap.get("uniquekey"))) {
			connection.setRequestProperty("X-IDEMPOTENCY-KEY", paramMap.get("uniquekey"));
		}
		if (null != paramMap.get("requestId") && !"".equals(paramMap.get("requestId"))) {
			connection.setRequestProperty("requestId", paramMap.get("requestId"));
		}
		if (null != paramMap.get("agentKey") && !"".equals(paramMap.get("agentKey"))) {
			connection.setRequestProperty("agentKey", paramMap.get("agentKey"));
		}
		if (null != paramMap.get("signature") && !"".equals(paramMap.get("signature"))) {
			connection.setRequestProperty("signature", paramMap.get("signature"));
		}
		connection.connect();

		//构建嵌套的 json数据
		OutputStream out = connection.getOutputStream();
		out.write(json.toString().getBytes());
		out.flush();
		out.close();

		BufferedReader reader = null;
//          读取响应
		if (200 == connection.getResponseCode()) {
			reader = new BufferedReader(new InputStreamReader(
					connection.getInputStream(), "UTF-8"));
		} else {
			reader = new BufferedReader(new InputStreamReader(
					connection.getErrorStream(), "UTF-8"));
		}
		String lines;
		StringBuffer sb = new StringBuffer("");
		while ((lines = reader.readLine()) != null) {
			lines = new String(lines.getBytes(), "utf-8");
			sb.append(lines);
		}
//              断开连接
		reader.close();
		connection.disconnect();
		return JSONObject.parseObject(sb.toString());
	}

	public static JSONObject sendHttpsJson(String postUrl, JSONObject json, Map<String, String> paramMap) {
		HttpsURLConnection connection = null;
		try {
			//创建连接
			URL url = new URL(postUrl);
			connection = (HttpsURLConnection) url.openConnection();
			//设置http连接属性
			connection.setDoOutput(true);
			connection.setDoInput(true);
			String requestMethod = "POST";
			if (null != paramMap.get("requestMethod") && !"".equals(paramMap.get("requestMethod"))) {
				requestMethod = paramMap.get("requestMethod");
			}
			connection.setRequestMethod(requestMethod); // 可以根据需要 提交 GET、POST、DELETE、INPUT等http提供的功能
			connection.setUseCaches(false);
			connection.setInstanceFollowRedirects(true);

			//设置http头 消息
			connection.setRequestProperty("Content-Type","application/json");  //设定 请求格式 json，也可以设定xml格式的
			//connection.setRequestProperty("Content-Type", "text/xml");   //设定 请求格式 xml，
			connection.setRequestProperty("Accept","application/json");//设定响应的信息的格式为 json，也可以设定xml格式的
//             connection.setRequestProperty("X-Auth-Token","xx");  //特定http服务器需要的信息，根据服务器所需要求添加
			// 设置BASIC AUTH
			if (null != paramMap.get("authorization") && !"".equals(paramMap.get("authorization"))) {
				connection.setRequestProperty("Authorization", paramMap.get("authorization"));
			}
			if (null != paramMap.get("uniquekey") && !"".equals(paramMap.get("uniquekey"))) {
				connection.setRequestProperty("X-IDEMPOTENCY-KEY", paramMap.get("uniquekey"));
			}
			connection.connect();

			//构建嵌套的 json数据
			OutputStream out = connection.getOutputStream();
			out.write(json.toString().getBytes());
			out.flush();
			out.close();

			BufferedReader reader = null;
//          读取响应
			if (200 == connection.getResponseCode()) {
				reader = new BufferedReader(new InputStreamReader(
						connection.getInputStream(), "UTF-8"));
			} else {
				reader = new BufferedReader(new InputStreamReader(
						connection.getErrorStream(), "UTF-8"));
			}
			String lines;
			StringBuffer sb = new StringBuffer("");
			while ((lines = reader.readLine()) != null) {
				lines = new String(lines.getBytes(), "utf-8");
				sb.append(lines);
			}
//              断开连接
			reader.close();
			connection.disconnect();
			return JSONObject.parseObject(sb.toString());
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			throw new RuntimeException(e);
		}
	}


	/**
	 * get HttpURLConnection
	 * @param strUrl url地址
	 * @return HttpURLConnection
	 * @throws IOException
	 */
	public static HttpURLConnection getHttpURLConnection(String strUrl)
			throws IOException {
		URL url = new URL(strUrl);
		HttpURLConnection httpURLConnection = (HttpURLConnection) url
				.openConnection();
		return httpURLConnection;
	}
	
	/**
	 * get HttpsURLConnection
	 * @param strUrl url地址
	 * @return HttpsURLConnection
	 * @throws IOException
	 */
	public static HttpsURLConnection getHttpsURLConnection(String strUrl)
			throws IOException {
		URL url = new URL(strUrl);
		HttpsURLConnection httpsURLConnection = (HttpsURLConnection) url
				.openConnection();
		return httpsURLConnection;
	}
	
	/**
	 * 获取不带查询串的url
	 * @param strUrl
	 * @return String
	 */
	public static String getURL(String strUrl) {

		if(null != strUrl) {
			int indexOf = strUrl.indexOf("?");
			if(-1 != indexOf) {
				return strUrl.substring(0, indexOf);
			} 
			
			return strUrl;
		}
		
		return strUrl;
		
	}
	
	/**
	 * 获取查询串
	 * @param strUrl
	 * @return String
	 */
	public static String getQueryString(String strUrl) {
		
		if(null != strUrl) {
			int indexOf = strUrl.indexOf("?");
			if(-1 != indexOf) {
				return strUrl.substring(indexOf+1, strUrl.length());
			} 
			return "";
		}
		
		return strUrl;
	}
	
	/**
	 * 查询字符串转换成Map<br/>
	 * name1=key1&name2=key2&...
	 * @param queryString
	 * @return
	 */
	public static Map queryString2Map(String queryString) {
		if(null == queryString || "".equals(queryString)) {
			return null;
		}
		
		Map m = new HashMap();
		String[] strArray = queryString.split("&");
		for(int index = 0; index < strArray.length; index++) {
			String pair = strArray[index];
			HttpClientUtil.putMapByPair(pair, m);
		}
		
		return m;
		
	}
	
	/**
	 * 把键值添加至Map<br/>
	 * pair:name=value
	 * @param pair name=value
	 * @param m
	 */
	public static void putMapByPair(String pair, Map m) {
		
		if(null == pair || "".equals(pair)) {
			return;
		}
		
		int indexOf = pair.indexOf("=");
		if(-1 != indexOf) {
			String k = pair.substring(0, indexOf);
			String v = pair.substring(indexOf+1, pair.length());
			if(null != k && !"".equals(k)) {
				m.put(k, v);
			}
		} else {
			m.put(pair, "");
		}
	}
	
	/**
	 * BufferedReader转换成String<br/>
	 * 注意:流关闭需要自行处理
	 * @param reader
	 * @return String
	 * @throws IOException
	 */
	public static String bufferedReader2String(BufferedReader reader) throws IOException {
		StringBuffer buf = new StringBuffer();
		String line = null;
		while( (line = reader.readLine()) != null) {
			buf.append(line);
			buf.append("\r\n");
		}
				
		return buf.toString();
	}
	
	/**
	 * 处理输出<br/>
	 * 注意:流关闭需要自行处理
	 * @param out
	 * @param data
	 * @param len
	 * @throws IOException
	 */
	public static void doOutput(OutputStream out, byte[] data, int len)
			throws IOException {
		int dataLen = data.length;
		int off = 0;
		while (off < data.length) {
			if (len >= dataLen) {
				out.write(data, off, dataLen);
				off += dataLen;
			} else {
				out.write(data, off, len);
				off += len;
				dataLen -= len;
			}

			// 刷新缓冲区
			out.flush();
		}

	}
	
	/**
	 * 获取SSLContext
	 * @param trustPasswd
	 * @param keyPasswd
	 * @return
	 * @throws NoSuchAlgorithmException 
	 * @throws KeyStoreException 
	 * @throws IOException 
	 * @throws CertificateException 
	 * @throws UnrecoverableKeyException 
	 * @throws KeyManagementException 
	 */
	public static SSLContext getSSLContext(
			FileInputStream trustFileInputStream, String trustPasswd,
			FileInputStream keyFileInputStream, String keyPasswd)
			throws NoSuchAlgorithmException, KeyStoreException,
			CertificateException, IOException, UnrecoverableKeyException,
			KeyManagementException {

		// ca
		TrustManagerFactory tmf = TrustManagerFactory.getInstance(HttpClientUtil.SunX509);
		KeyStore trustKeyStore = KeyStore.getInstance(HttpClientUtil.JKS);
		trustKeyStore.load(trustFileInputStream, HttpClientUtil
				.str2CharArray(trustPasswd));
		tmf.init(trustKeyStore);

		final char[] kp = HttpClientUtil.str2CharArray(keyPasswd);
		KeyManagerFactory kmf = KeyManagerFactory.getInstance(HttpClientUtil.SunX509);
		KeyStore ks = KeyStore.getInstance(HttpClientUtil.PKCS12);
		ks.load(keyFileInputStream, kp);
		kmf.init(ks, kp);

		SecureRandom rand = new SecureRandom();
		SSLContext ctx = SSLContext.getInstance(HttpClientUtil.TLS);
		ctx.init(kmf.getKeyManagers(), tmf.getTrustManagers(), rand);

		return ctx;
	}
	
	/**
	 * 获取CA证书信息
	 * @param cafile CA证书文件
	 * @return Certificate
	 * @throws CertificateException
	 * @throws IOException
	 */
	public static Certificate getCertificate(File cafile)
			throws CertificateException, IOException {
		CertificateFactory cf = CertificateFactory.getInstance("X.509");
		FileInputStream in = new FileInputStream(cafile);
		Certificate cert = cf.generateCertificate(in);
		in.close();
		return cert;
	}
	
	/**
	 * 字符串转换成char数组
	 * @param str
	 * @return char[]
	 */
	public static char[] str2CharArray(String str) {
		if(null == str) return null;
		
		return str.toCharArray();
	}
	
	/**
	 * 存储ca证书成JKS格式
	 * @param cert
	 * @param alias
	 * @param password
	 * @param out
	 * @throws KeyStoreException
	 * @throws NoSuchAlgorithmException
	 * @throws CertificateException
	 * @throws IOException
	 */
	public static void storeCACert(Certificate cert, String alias,
			String password, OutputStream out) throws KeyStoreException,
			NoSuchAlgorithmException, CertificateException, IOException {
		KeyStore ks = KeyStore.getInstance("JKS");

		ks.load(null, null);

		ks.setCertificateEntry(alias, cert);

		// store keystore
		ks.store(out, HttpClientUtil.str2CharArray(password));

	}
	
	public static InputStream String2Inputstream(String str) {
		return new ByteArrayInputStream(str.getBytes());
	}
	
	/**
	 * InputStream转换成Byte
	 * 注意:流关闭需要自行处理
	 * @param in
	 * @return byte
	 * @throws Exception
	 */
	public static byte[] InputStreamTOByte(InputStream in) throws IOException{  
		
		int BUFFER_SIZE = 4096;  
		ByteArrayOutputStream outStream = new ByteArrayOutputStream(); 
        byte[] data = new byte[BUFFER_SIZE];  
        int count = -1;  
        
        while((count = in.read(data,0,BUFFER_SIZE)) != -1)  
            outStream.write(data, 0, count);  
          
        data = null;  
        byte[] outByte = outStream.toByteArray();
        outStream.close();
        
        return outByte;  
    } 
	
	/**
	 * InputStream转换成String
	 * 注意:流关闭需要自行处理
	 * @param in
	 * @param encoding 编码
	 * @return String
	 * @throws Exception
	 */
	public static String InputStreamTOString(InputStream in,String encoding) throws IOException{  
        return new String(InputStreamTOByte(in),encoding);
    }

	/**
	 * http发送post json请求
	 */
	public static JSONObject httpPost(String url, JSONObject jsonObject) {
		// post请求返回结果
		CloseableHttpClient httpClient = HttpClients.createDefault();
		JSONObject jsonResult = null;
		HttpPost httpPost = new HttpPost(url);
		// 设置请求和传输超时时间
		httpPost.setConfig(requestConfig);
		try {
			//设置参数解决中文乱码
			if (null != jsonObject) {
				StringEntity entity = new StringEntity(jsonObject.toString(), encoding);
				entity.setContentEncoding(encoding);
				entity.setContentType("application/json");
				httpPost.setEntity(entity);
			}
			//发送请求
			CloseableHttpResponse result = httpClient.execute(httpPost);

			if (result.getStatusLine().getStatusCode() == HttpStatus.SC_OK) {
				String str = "";
				try {
					// 读取服务器返回的json数据（然后解析）
					str = EntityUtils.toString(result.getEntity(), encoding);
					// 把json字符串转换成json对象
					jsonResult = JSONObject.parseObject(str);
				} catch (Exception e) {
					logger.error("post请求提交失败:" + url, e);
				}
			}
		} catch (IOException e) {
			logger.error("请求提交失败:" + url, e);
		} finally {
			httpPost.releaseConnection();
		}

		return jsonResult;
	}

	/**
	 * 向指定URL发送GET方法的请求
	 *
	 * @param url
	 *            发送请求的URL
	 * @param param
	 *            请求参数，请求参数应该是 name1=value1&name2=value2 的形式。
	 * @return URL 所代表远程资源的响应结果
	 */
	public static String sendGet(String url, String param) {
		String result = "";
		BufferedReader in = null;
		try {
			String urlNameString = url + "?" + param;
			URL realUrl = new URL(urlNameString);
			// 打开和URL之间的连接
			URLConnection connection = realUrl.openConnection();
			// 设置通用的请求属性
			connection.setRequestProperty("accept", "*/*");
			connection.setRequestProperty("connection", "Keep-Alive");
			connection.setRequestProperty("user-agent",
					"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
			// 建立实际的连接
			connection.connect();
			// 获取所有响应头字段
			Map<String, List<String>> map = connection.getHeaderFields();
			// 遍历所有的响应头字段
			for (String key : map.keySet()) {
				System.out.println(key + "--->" + map.get(key));
			}
			// 定义 BufferedReader输入流来读取URL的响应
			in = new BufferedReader(new InputStreamReader(
					connection.getInputStream()));
			String line;
			while ((line = in.readLine()) != null) {
				result += line;
			}
		} catch (Exception e) {
			System.out.println("发送GET请求出现异常！" + e);
			e.printStackTrace();
		}
		// 使用finally块来关闭输入流
		finally {
			try {
				if (in != null) {
					in.close();
				}
			} catch (Exception e2) {
				e2.printStackTrace();
			}
		}
		return result;
	}
}
