package com.demo.openapi;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.*;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

/**
 * 时间工具类
 */
public class DateFormatUtil {

    public static final DateFormat yMdTHmsSformat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    public static final DateFormat yyMdHmsSformat = new SimpleDateFormat("yyMMddHHmmssSS");
    public static final DateFormat yyMdHmsformat = new SimpleDateFormat("yyyyMMddHHmmss");
    public static final DateFormat yyMdHmformat = new SimpleDateFormat("yyyyMMddhhmm");
    public static final DateFormat HHformat = new SimpleDateFormat("HH");
    public static final DateFormat yMdformat = new SimpleDateFormat("yyyy-MM-dd");
    public static final DateFormat yMdHformat = new SimpleDateFormat("yyyy-MM-dd HH");
    public static final DateFormat y_M_d_H_m_sFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final DateFormat yMformat = new SimpleDateFormat("yyyy-MM");

    // 14/10/2018 13:25
    public static final DateFormat dMyHmHformat = new SimpleDateFormat("dd/MM/yyyy HH:mm");

    public static final DateFormat yyMdformat = new SimpleDateFormat("yyyyMMdd");

    public static final SimpleDateFormat orderIdFormatter = new SimpleDateFormat("yyyyMMddhhmmssSSS");

    public static DateTimeFormatter y_M_dFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static DateTimeFormatter y_M_d_H_m_sFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static DateTimeFormatter HHFormatter = DateTimeFormatter.ofPattern("HH");
    public static DateTimeFormatter yMdHmFormatter = DateTimeFormatter.ofPattern("yyyyMMddHHmm");
    public static DateTimeFormatter yMdHmsFormatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    public static DateTimeFormatter yMdHmsSFormatter = DateTimeFormatter.ofPattern("yyyyMMddhhmmssSSS");
    public static DateTimeFormatter yyFormatter = DateTimeFormatter.ofPattern("yy");
    public static DateTimeFormatter yyMdFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");
    public static final DateFormat MMyyyyformat = new SimpleDateFormat("MM/yyyy");
    public static final DateFormat dMyHformat = new SimpleDateFormat("dd/MM/yyyy");

    public static String format(DateFormat dateFormat, Date date) {
        try {
            return dateFormat.format(date);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String format(DateFormat dateFormat, Date date, int addDay) {
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(Calendar.DAY_OF_MONTH, addDay);

            return dateFormat.format(calendar.getTime());
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }


    /**
     * 获取今天的时间-服务器上时间为UTC时间，本地时间为UTC+7时间
     * @return
     */
    public static String getNowUtcDate(DateTimeFormatter formatter) {
        ZoneId zoneId = ZoneId.of("UTC+0");
        ZonedDateTime dd = ZonedDateTime.now(zoneId);
        return formatter.format(dd);
    }

    /**
     * 获取今天的时间-服务器上时间为UTC时间，本地时间为UTC+8时间
     * @return
     */
    public static String getNowDate(DateTimeFormatter formatter) {
        ZoneId zoneId = ZoneId.of("UTC+7");
        ZonedDateTime dd = ZonedDateTime.now(zoneId);
        return formatter.format(dd);
    }

    public static String getDate(DateTimeFormatter formatter,Date date) {
        ZoneId zoneId = ZoneId.of("UTC+7");
        ZonedDateTime dd = ZonedDateTime.ofInstant(date.toInstant(), zoneId);
        return formatter.format(dd);
    }

    /**
     * 获取当前时间-服务器上时间为UTC时间，本地时间为UTC+7时间
     * @return
     */
    public static ZonedDateTime getNowZonedDateTime() {
        ZoneId zoneId = ZoneId.of("UTC+7");
        ZonedDateTime dd = ZonedDateTime.now(zoneId);
        return dd;
    }

    /**
     * 获取当前的Date类型日期
     * @return
     */
    public static Date getNowDate() {
        Date date = null;
        try {
            ZoneId zoneId = ZoneId.of("UTC+7");
            ZonedDateTime dd = ZonedDateTime.now(zoneId);
            LocalDateTime localDateTime = dd.toLocalDateTime();

            date = yMdTHmsSformat.parse(localDateTime.toString());

        } catch (Exception e) {
            e.printStackTrace();
        }

        return date;
    }

    /**
     * 两个日期是否是同一天
     * @param date1
     * @param date2
     * @return
     */
    public static boolean isSameDay(Date date1, Date date2) {
        if (null != date1 && null != date2) {
            Calendar cal1 = Calendar.getInstance();
            cal1.setTime(date1);

            Calendar cal2 = Calendar.getInstance();
            cal2.setTime(date2);

            return cal1.get(Calendar.YEAR) == cal2.get(Calendar.YEAR)
                    && cal1.get(Calendar.MONTH) == cal2.get(Calendar.MONTH)
                    && cal1.get(Calendar.DAY_OF_MONTH) == cal2.get(Calendar.DAY_OF_MONTH);
        }
        return false;
    }

    public static Date parse(DateFormat yyMdHmsSformat, String time) {
        try {
            return yyMdHmsSformat.parse(time);
        } catch (Exception e) {

        }
        return null;
    }




    /**
     * 获取当前的Date类型日期
     * @return
     */
    public static Date getNowTime() {
        Date date = null;
        try {
            ZoneId zoneId = ZoneId.of("UTC+7");
            ZonedDateTime dd = ZonedDateTime.now(zoneId);
            LocalDateTime localDateTime = dd.toLocalDateTime();

            date = yMdTHmsSformat.parse(localDateTime.toString());

        } catch (Exception e) {
            e.printStackTrace();
        }

        return date;
    }

    /**
     * 获取UTC+0 time
     * @return
     */
    public static Date getNowUTCTime() {
        Date date = null;
        try {
            ZoneId zoneId = ZoneId.of("UTC+0");
            ZonedDateTime dd = ZonedDateTime.now(zoneId);
            LocalDateTime localDateTime = dd.toLocalDateTime();

            date = y_M_d_H_m_sFormat.parse(localDateTime.toString());

        } catch (Exception e) {
            e.printStackTrace();
        }

        return date;
    }



    /**
     * 判定日期是否符合格式
     * @param dateString
     * @param formatPattern 例如 yyyy/MM/dd HH:mm:ss
     * @return
     */
    public static boolean isValidDate(String dateString,String formatPattern) {
        boolean convertSuccess = true;
        // 指定日期格式为四位年/两位月份/两位日期，注意yyyy/MM/dd区分大小写；
        SimpleDateFormat format = new SimpleDateFormat(formatPattern);
        try {
            // 设置lenient为false.
            // 否则SimpleDateFormat会比较宽松地验证日期，比如2007/02/29会被接受，并转换成2007/03/01
            format.setLenient(false);
            format.parse(dateString);
        } catch (ParseException e) {
            // e.printStackTrace();
            // 如果throw java.text.ParseException或者NullPointerException，就说明格式不对
            convertSuccess = false;
        }
        return convertSuccess;
    }



    /**
     * 比较日期大小
     * @param DATE1
     * @param DATE2
     * @param pattern
     * @return
     */
    public static int compareDate(String DATE1, String DATE2,String pattern) {
        DateFormat df = new SimpleDateFormat(pattern);
        try {
            Date dt1 = df.parse(DATE1);
            Date dt2 = df.parse(DATE2);
            if (dt1.getTime() > dt2.getTime()) {
//                System.out.println("dt1 在dt2前");
                return 1;
            } else if (dt1.getTime() < dt2.getTime()) {
//                System.out.println("dt1在dt2后");
                return -1;
            } else {
                return 0;
            }
        } catch (Exception exception) {
            exception.printStackTrace();
        }
        return 0;
    }


    /**
     * 比较日期大小
     * @return
     */
    public static int compareDate(Date dt1, Date dt2) {
        if (dt1.getTime() > dt2.getTime()) {
//                System.out.println("dt1 在dt2前");
            return 1;
        } else if (dt1.getTime() < dt2.getTime()) {
//                System.out.println("dt1在dt2后");
            return -1;
        } else {
            return 0;
        }
    }



    /**
     * 获取当前日期
     * @return
     */
    public static String getCurrentDateString() {
        return format(yMdformat,new Date());
    }


    /**
     * 判断是否小于100岁
     * @param idNumber
     * @return
     */
    public static boolean isLessThan100(String idNumber){
        String dmy = idNumber.substring(idNumber.length()-10,idNumber.length()-4);
        String yy = dmy.substring(dmy.length()-2);
//        String mm = dmy.substring(dmy.length()-4,dmy.length()-2);
//        String dd = dmy.substring(dmy.length()-6,dmy.length()-4);
//        int ddInt = Integer.parseInt(dd);
//        if(ddInt > 32){
//            ddInt = ddInt - 40;
//            if(ddInt < 10){
//                dd = "0"+ddInt;
//            }else {
//                dd = ddInt+"";
//            }
//        }
//        String ymd = yy+mm+dd;
//        String dMy = dd+mm+yy;

        int yyInt = Integer.parseInt(yy);
        String curYear = getNowDate(yyFormatter);
        int curYearInt = Integer.parseInt(curYear);

        int diffYear = curYearInt + 100 - yyInt;
        //大于等于100岁
        if(diffYear >= 100){
            return false;
        }
        return true;

    }

    public static String diffMonthFromNow(Date recentDate){
        Calendar bef = Calendar.getInstance();
        Calendar aft = Calendar.getInstance();
        bef.setTime(new Date());
        aft.setTime(recentDate);
        int result = aft.get(Calendar.MONTH) - bef.get(Calendar.MONTH);
        int month = (aft.get(Calendar.YEAR) - bef.get(Calendar.YEAR)) * 12;
        int diffMoth = Math.abs(month + result);
        if(diffMoth > 6){
            return "6 months ago";
        }else if(diffMoth >= 4 && diffMoth <= 6){
            return "Between 4 and 6 months";
        }else if(diffMoth >= 1 && diffMoth <= 3){
            return "Between 1 and 3 months";
        }else {
            return "Less than 1 month";
        }
    }

    /**
     * 通过时间秒毫秒数判断两个时间的间隔
     * @return
     */
    public static String differentDaysByMillisecond(Date recentDate,Date curDate) {
//        Date curDate = new Date();
        if(recentDate == null||curDate == null){
            return null;
        }
        int days = Math.abs((int) ((curDate.getTime() - recentDate.getTime()) / (1000*3600*24)));
        if(days > 90){
            return "91d+";
        }else if(days > 60  && days <= 90){
            return "61-90d";
        }else if(days > 30 && days <= 60){
            return "31-60d";
        }else {
            return "1-30d";
        }
    }


    public static LocalDateTime date2LocalDateTime(Date date){
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDateTime localDateTime = instant.atZone(zoneId).toLocalDateTime();
        return localDateTime;
    }

    public static LocalDate date2LocalDate(Date date){
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDate localDate = instant.atZone(zoneId).toLocalDate();
        return localDate;
    }


    /**
     * 跟当前日期相差多少个月
     * @param localDate
     * @return
     */
    public static int diffMonthFromNow(LocalDate localDate){
        LocalDate curLocalDate = LocalDate.now();
        Period p=Period.between(localDate, curLocalDate);
//        System.out.println(localDate.minusMonths(1).format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
//        System.out.println("相差年: "+p.getYears()+" 相差月 :"+p.getMonths() +" 相差天:"+p.getTimeSlice());
        int month = p.getMonths();
        int day = p.getDays();
        if(day >= 0){
            month ++;
        }
        return month;
    }


    public static int diffMonthFromBackTrackDate(LocalDate localDate, LocalDate backTrackDate) {
        Period p=Period.between(localDate, backTrackDate);
//        System.out.println(localDate.minusMonths(1).format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
//        System.out.println("相差年: "+p.getYears()+" 相差月 :"+p.getMonths() +" 相差天:"+p.getTimeSlice());
        int month = p.getMonths();
        int day = p.getDays();
        if(day >= 0){
            month ++;
        }
        return month;
    }

    /**
     * 两个日期相差多少天
     * @param lastDay
     * @param curDay
     * @return
     */
    public static int diffDays(Date lastDay, Date curDay){
        if(lastDay == null|| curDay == null){
            return 0;
        }

//        long diff = lastDay.getTime() - curDay.getTime();
        int days = (int) ((lastDay.getTime() - curDay.getTime())/(1000 * 60 * 60 * 24));
//        BigDecimal days =  new BigDecimal((lastDay.getTime() - curDay.getTime())/(1000 * 60 * 60 * 24)).setScale(50,BigDecimal.ROUND_UP);
//        if(diff > 0 && days.compareTo(BigDecimal.ZERO) == 0){
//            days = BigDecimal.ONE;
//        }
//        return days.intValue();//(int)Math.ceil(days);
        return days;
    }


    /**
     将10 or 13 位时间戳转为时间字符串
     convert the number 1407449951 1407499055617 to date/time format timestamp
     */
    public static String timestamp2Date(Long timestamp) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (timestamp.toString().length() == 13) {
            String date = sdf.format(new Date(timestamp));
            return date;
        } else {
            String date = sdf.format(new Date(timestamp * 1000L));
            return date;
        }
    }



    /**
     * 计算2个日期之间相差的  相差多少年月日
     * 比如：2011-02-02 到  2017-03-02 相差 6年，1个月，0天
     * @param fromDate YYYY-MM-DD
     * @param toDate YYYY-MM-DD
     * @return 年,月,日 例如 1,1,1
     */
    public static String dayComparePrecise(String fromDate, String toDate){

        Period period = Period.between(LocalDate.parse(fromDate), LocalDate.parse(toDate));

        StringBuffer sb = new StringBuffer();
        sb.append(period.getYears()).append(",")
                .append(period.getMonths()).append(",")
                .append(period.getDays());
        return sb.toString();
    }

    /**
     * 比较距离当前多少年
     * @param fromDate
     * @return
     */
    public static Integer dayCompareNowPrecise(String fromDate){
        Period period = Period.between(LocalDate.parse(fromDate), LocalDate.now());
        int year = period.getYears();
        int month = period.getMonths();
        //19年1个月计为19,19年11月计为20 四舍五入取整
        if(month >= 5){
            year++;
        }
        return year;
    }

    /**
     * 比较日期相差多少个小时
     * @param fromDate
     * @return
     */
    public static int hourCompareNow(Date fromDate,Date toDate){
        long from = fromDate.getTime();
        long to = toDate.getTime();
        int hours = (int) ((to - from)/(1000 * 60 * 60));
        return hours;
    }

    /**
     * 获取当前小时
     * @param date
     * @return
     */
    public static int getCurrentHour (Date date){
        String HH = HHformat.format(date);
//        System.out.println("date hour : " + HH);
        int hh = Integer.parseInt(HH);
//        if(hh < 10 || hh >= 21){
//            return true;
//        }
//        return false;
        return hh;
    }

    /**
     * 获取当天还剩多少秒
     * @return
     */
    public static Long getLeftSeconds() {
        Calendar curDate = Calendar.getInstance();
        Calendar tommorowDate = new GregorianCalendar(curDate
                .get(Calendar.YEAR), curDate.get(Calendar.MONTH), curDate
                .get(Calendar.DATE) + 1, 0, 0, 0);
        return (tommorowDate.getTimeInMillis() - curDate.getTimeInMillis()) / 1000;
    }


        public static void main(String[] args) throws ParseException {

        }



}
