package com.demo.openapi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.tomcat.util.http.fileupload.IOUtils;

import javax.crypto.Cipher;
import java.io.ByteArrayOutputStream;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.*;

/**
 * 还款
 */
public class CreateBillDemo {
    // 测试环境
//    private static final String payUrl = "http://openapi.sandbox.benri-pay.com/gateway/pay";

    private static final String MCH_CODE = "S82020090601239883434211";  // 商户号
    private static final String PLAT_PUBLIC_KEY = "MIGfMA0GXSRGSFSDFDSFADCBiQKBgQCaSGrGmLysT0xxvu4u1K1cf1VWcDhm83aTm64GWZGyVmY3icnuRyDoiVVsplGw6bUtZ23V/Wo2ctadTIQ+bsvj2EgiKV25ulglC5Xj2ws4icIsP5E7VlxIQ8QCXt9fyWoLRUa3c4fQrYr6wUFoPYTiBHh+FV/21TCfB2IqESBl6wIDAQAB";  // 平台公钥
    private static final String MCH_PRIVATE_KEY = "MIICdwIBADANBgkqMIGfMA0GXSRGSFSDFDSFADCBiQKBgQCaSGrGmLysT0xxvu4u1K1cf1VWcDhm83aTm64GWZGyVmY3icnuRyDoiVjz29T8G/DOBStGEyQ5uFcp0zgMG+FOX37/ctosOJMSyJOHG0KM3HXxg0TaDz6DZKino2naWear7Qu9WhagX/G6nFoisWKrjtIW1KSMFjdWlJmtdkoXCoJI196TOqFLWVvsdLobbvvOQe6mPxLqhxFUnlPds8cGQNMuTAkpOY7AgMBAAECgYEAiD7jpsEuzpJzYT+/AFZDOWI4Q0N0ACKuaSc2FQvA7qkWsGiUfQ4UZoqZKUG6xKW1zI6B9SaT7OL+5++X+iKt66wXuZ8A7Ulp0IBbuQtLQe7p5GQCWmvZo9wjwtOHmd7oMZWmy3VkTGlpy2TlMGVxOyJOOWde/O13LWtW8g+JOAECQQD2d4b9ba7L/EV28R3fw4qg6cbaN68xFU23D3oID3/CA706ETjxqwMTg+eWrBQayPKMkTQsQGKu/lzVw3kgkhPBAkEAzhA7jrpeTs7vTHn8x4OSqQiY8EnA3TnZMYuTOfBZhnMv6WhadqAhKgdG00puXUf/HFp1KCuRwkMtUkJyoi2I+wJBAOERf7UYH0Jp6elXAEfhokuVkCCgLxysbp6XxIFt3eYHUhqftZeC6jk9ABQoqedXz56rzrAGT9erso0GhytGGkECQBx9aA6au9E/kRxMvWNEULGoK6UFPXIYvmu4NXnMPkR1holJ0UAXcZ5i9SrfXpTtEFt2Mj6Ej5mBOjHmV/0OOKMCQHEVioJ/VSdfX28ouvoYxAE83hRN9CPifj+qEMKbpS7XPlKjN+1FLrJ5asXVgIFqCYKGKSB0s12xW0ODlOgTeio=";  // 商户私钥

    //正式环境 咨询商务获取
    private static final String payUrl = "http://xxx.xxx";


    public static void main(String[] args) {
        //    BT("BT", "Permata Bank"),

        String merchantCode = MCH_CODE;                                             // 商户号
        String method = "BT";                                                       // 支付方式，I1指BNI银行
        String orderNum = "T" + System.currentTimeMillis();                         // 商户订单号
        String payMoney = "50000";                                                  // 订单金额
        String productDetail = "Test Pay10";                                          // 订单详情
        String name = "neo";                                                        // 客户名称
        String email = "test@email.com";                                            // 客户邮箱，需要符合规范 xx@xx.xx
        String notifyUrl = "http://xxx.com/gateway/callback";                                 // 回调地址，即客户支付成功后通知地址
        String dateTime = "20200707082206";                                         // 时间戳 格式 yyyyMMddHHmmss
        String phone = "082100138000";                                              // 手机号，OVO钱包该手机号必须为注册OVO钱包对应手机号，形如：082113079955，其他支付方式只需要符合手机号格式规则（纯数值）即可，不做检验
        Map<String, String> createMap = new HashMap<>();
        createMap.put("merchantCode", merchantCode);
        createMap.put("method", method);
        createMap.put("orderNum", orderNum);
        createMap.put("payMoney", payMoney);
        createMap.put("productDetail", productDetail);
        createMap.put("name", name);
        createMap.put("email", email);
        createMap.put("notifyUrl", notifyUrl);
        createMap.put("dateTime", dateTime);
        createMap.put("phone", phone);
        createMap.put("expiryPeriod", "4320"); // 分钟，不传默认4320即72小时

        List<String> paramNameList = new ArrayList<>();
        for (String key : createMap.keySet()) {
            paramNameList.add(key);
        }
        Collections.sort(paramNameList);  // 排序key
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < paramNameList.size(); i++) {
            String key = paramNameList.get(i);
            stringBuilder.append(createMap.get(key));  // 拼接参数
        }
        String keyStr = stringBuilder.toString();  // 得到待加密的字符串
        System.out.println("keyStr:" + keyStr);
        String signedStr = "";
        try {
            signedStr = privateEncrypt(keyStr, getPrivateKey(MCH_PRIVATE_KEY));  // 私钥加密
        } catch (Exception e) {
            System.out.println(e);
        }
        createMap.put("sign", signedStr);

        String postStr = JSON.toJSONString(createMap);
        JSONObject postJson = JSONObject.parseObject(postStr);
        System.out.println("postJson:" + postJson);
        Long start = System.currentTimeMillis();
        JSONObject returnObj = doPost(payUrl, postJson);  // 发送 post json请求
        Long end = System.currentTimeMillis();
        System.out.println("耗时:" + (end - start));
        System.out.println("return:" + returnObj);

        boolean pass = false;
        try {
            pass = verifySign(returnObj, PLAT_PUBLIC_KEY);  // 签名验证
        } catch (Exception e) {
            System.out.println(e);
        }
        System.out.println(pass);
    }

    /**
     * 验证签名
     *
     * @param params
     * @return
     */
    public static boolean verifySign(JSONObject params, String publickey) {
        String platSign = params.getString("platSign"); // 签名
        System.out.println("platSign:" + platSign);
        List<String> paramNameList = new ArrayList<>();
        for (String key : params.keySet()) {
            if (!"platSign".equals(key)) {
                paramNameList.add(key);
            }
        }
        Collections.sort(paramNameList);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < paramNameList.size(); i++) {
            String name = paramNameList.get(i);
            stringBuilder.append(params.getString(name));
        }
        System.out.println("keys:" + stringBuilder);

        String decryptSign = "";
        try {
            decryptSign = publicDecrypt(platSign, getPublicKey(publickey));
        } catch (Exception e) {
            System.out.println(e.toString());
        }
        System.out.println("decryptSign:" + decryptSign);

        if (!stringBuilder.toString().equalsIgnoreCase(decryptSign)) {
            return false;
        }
        return true;
    }

    /**
     * 私钥加密
     *
     * @param data
     * @param privateKey
     * @return
     */

    public static String privateEncrypt(String data, RSAPrivateKey privateKey) {
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(Cipher.ENCRYPT_MODE, privateKey);
            return Base64.encodeBase64String(rsaSplitCodec(cipher, Cipher.ENCRYPT_MODE, data.getBytes("UTF-8"), privateKey.getModulus().bitLength()));
        } catch (Exception e) {
            throw new RuntimeException("加密字符串[" + data + "]时遇到异常", e);
        }
    }

    /**
     * 公钥解密
     *
     * @param data
     * @param publicKey
     * @return
     */

    public static String publicDecrypt(String data, RSAPublicKey publicKey) {
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(Cipher.DECRYPT_MODE, publicKey);
            return new String(rsaSplitCodec(cipher, Cipher.DECRYPT_MODE, Base64.decodeBase64(data), publicKey.getModulus().bitLength()), "UTF-8");
        } catch (Exception e) {
            throw new RuntimeException("解密字符串[" + data + "]时遇到异常", e);
        }
    }

    /**
     * 得到私钥
     *
     * @param privateKey 密钥字符串（经过base64编码）
     * @throws Exception
     */
    public static RSAPrivateKey getPrivateKey(String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        //通过PKCS#8编码的Key指令获得私钥对象
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64(privateKey));
        RSAPrivateKey key = (RSAPrivateKey) keyFactory.generatePrivate(pkcs8KeySpec);
        return key;
    }

    /**
     * 得到公钥
     *
     * @param publicKey 密钥字符串（经过base64编码）
     * @throws Exception
     */
    public static RSAPublicKey getPublicKey(String publicKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        //通过X509编码的Key指令获得公钥对象
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(Base64.decodeBase64(publicKey));
        RSAPublicKey key = (RSAPublicKey) keyFactory.generatePublic(x509KeySpec);
        return key;
    }

    private static byte[] rsaSplitCodec(Cipher cipher, int opmode, byte[] datas, int keySize) {
        int maxBlock = 0;
        if (opmode == Cipher.DECRYPT_MODE) {
            maxBlock = keySize / 8;
        } else {
            maxBlock = keySize / 8 - 11;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        byte[] buff;
        int i = 0;
        try {
            while (datas.length > offSet) {
                if (datas.length - offSet > maxBlock) {
                    buff = cipher.doFinal(datas, offSet, maxBlock);
                } else {
                    buff = cipher.doFinal(datas, offSet, datas.length - offSet);
                }
                out.write(buff, 0, buff.length);
                i++;
                offSet = i * maxBlock;
            }
        } catch (Exception e) {
            throw new RuntimeException("加解密阀值为[" + maxBlock + "]的数据时发生异常", e);
        }
        byte[] resultDatas = out.toByteArray();
        IOUtils.closeQuietly(out);
        return resultDatas;
    }

    public static JSONObject doPost(String url, JSONObject json) {
        HttpClient client = new DefaultHttpClient();
        HttpPost post = new HttpPost(url);
        post.setHeader("x-forwarded-for", "192.168.0.1");
        JSONObject response = null;
        try {
            StringEntity s = new StringEntity(json.toString());
            s.setContentEncoding("UTF-8");
            s.setContentType("application/json");//发送json数据需要设置contentType
            post.setEntity(s);
            HttpResponse res = client.execute(post);
            if (res.getStatusLine().getStatusCode() == HttpStatus.SC_OK) {
                HttpEntity entity = res.getEntity();
                String result = EntityUtils.toString(res.getEntity());// 返回json格式：
                response = JSONObject.parseObject(result);
            }
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return response;
    }
}
