package com.demo.openapi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.crypto.Cipher;
import javax.servlet.http.HttpServletRequest;
import java.io.ByteArrayOutputStream;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.*;

/**
 * @description: 回调demo
 **/
@RestController
public class CallbackDemo {

    private static final String PLAT_PUBLIC_KEY = "MIGfMA0GXSRGSFSDFDSFADCBiQKBgQCaSGrGmLysT0xxvu4u1K1cf1VWcDhm83aTm64GWZGyVmY3icnuRyDoiVVsplGw6bUtZ23V/Wo2ctadTIQ+bsvj2EgiKV25ulglC5Xj2ws4icIsP5E7VlxIQ8QCXt9fyWoLRUa3c4fQrYr6wUFoPYTiBHh+FV/21TCfB2IqESBl6wIDAQAB";  // 平台公钥

    @RequestMapping(value = "/gateway/callback")
    public String callback(@RequestBody String requestBody, HttpServletRequest request) {
        System.out.println("callback requestBody "+requestBody);
        JSONObject notifyJson = getRequestParams(request);
        Boolean pass = verifySign(notifyJson, PLAT_PUBLIC_KEY);  // 签名验证
        if (pass) {
            if ("00".equals(notifyJson.getString(""))) {
                // 成功操作，需要判断该订单状态是否已更改成功，避免订单重复操作
            }
        } else {
            return "verify sign failed";
        }
        return "SUCCESS";
    }

    /**
     * 将请求值装换成JSONObject
     *
     * @param request
     * @return
     */
    public static JSONObject getRequestParams(HttpServletRequest request) {
        Map map = new HashMap();
        Enumeration<String> it = request.getParameterNames();
        while (it.hasMoreElements()) {
            String name = it.nextElement();
            String value = request.getParameter(name);
            value = (StringUtils.isBlank(value)) || (value.equals("null")) ? "" : value;
            map.put(name, value);
        }
        return JSONObject.parseObject(JSON.toJSONString(map));
    }

    /**
     * 验证签名
     *
     * @param params
     * @return
     */
    public static boolean verifySign(JSONObject params, String publickey) {
        String platSign = params.getString("platSign"); // 签名
        System.out.println("platSign:" + platSign);
        List<String> paramNameList = new ArrayList<>();
        for (String key : params.keySet()) {
            if (!"platSign".equals(key)) {
                paramNameList.add(key);
            }
        }
        Collections.sort(paramNameList);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < paramNameList.size(); i++) {
            String name = paramNameList.get(i);
            stringBuilder.append(params.getString(name));
        }
        System.out.println("keys:" + stringBuilder);

        String decryptSign = "";
        try {
            decryptSign = publicDecrypt(platSign, getPublicKey(publickey));
        } catch (Exception e) {
            System.out.println(e.toString());
        }
        System.out.println("decryptSign:" + decryptSign);

        if (!stringBuilder.toString().equalsIgnoreCase(decryptSign)) {
            return false;
        }
        return true;
    }

    /**
     * 得到公钥
     *
     * @param publicKey 密钥字符串（经过base64编码）
     * @throws Exception
     */
    public static RSAPublicKey getPublicKey(String publicKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        //通过X509编码的Key指令获得公钥对象
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(Base64.decodeBase64(publicKey));
        RSAPublicKey key = (RSAPublicKey) keyFactory.generatePublic(x509KeySpec);
        return key;
    }

    private static byte[] rsaSplitCodec(Cipher cipher, int opmode, byte[] datas, int keySize) {
        int maxBlock = 0;
        if (opmode == Cipher.DECRYPT_MODE) {
            maxBlock = keySize / 8;
        } else {
            maxBlock = keySize / 8 - 11;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        byte[] buff;
        int i = 0;
        try {
            while (datas.length > offSet) {
                if (datas.length - offSet > maxBlock) {
                    buff = cipher.doFinal(datas, offSet, maxBlock);
                } else {
                    buff = cipher.doFinal(datas, offSet, datas.length - offSet);
                }
                out.write(buff, 0, buff.length);
                i++;
                offSet = i * maxBlock;
            }
        } catch (Exception e) {
            throw new RuntimeException("加解密阀值为[" + maxBlock + "]的数据时发生异常", e);
        }
        byte[] resultDatas = out.toByteArray();
        IOUtils.closeQuietly(out);
        return resultDatas;
    }

    /**
     * 公钥解密
     *
     * @param data
     * @param publicKey
     * @return
     */

    public static String publicDecrypt(String data, RSAPublicKey publicKey) {
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(Cipher.DECRYPT_MODE, publicKey);
            return new String(rsaSplitCodec(cipher, Cipher.DECRYPT_MODE, Base64.decodeBase64(data), publicKey.getModulus().bitLength()), "UTF-8");
        } catch (Exception e) {
            throw new RuntimeException("解密字符串[" + data + "]时遇到异常", e);
        }
    }
}
    